# Code to create a simple quote table that stores an author ID
CREATE TABLE fq_quotes 
(
 quote_id INT NOT NULL AUTO_INCREMENT PRIMARY KEY,
 quotetext TEXT,
 quotedate DATE NOT NULL,
 author_id INT
)ENGINE = InnoDB;

# Code to create a simple author table
CREATE TABLE fq_author 
(
 author_id INT NOT NULL AUTO_INCREMENT PRIMARY KEY,
 name VARCHAR(255),
 email VARCHAR(255)
)ENGINE = InnoDB;

# Code to create a lookup table for quote-category relationship
CREATE TABLE fq_quotecategory 
(
 quote_id INT NOT NULL,
 category_id INT NOT NULL,
 PRIMARY KEY (quote_id, category_id)
)ENGINE = InnoDB;

# Code to create a simple category table
CREATE TABLE fq_category 
(
 category_id INT NOT NULL AUTO_INCREMENT PRIMARY KEY,
 name VARCHAR(255)
)ENGINE = InnoDB;

